//==========================================================
// gameItems.js
//==========================================================

//==========================================================
// This script is for the building a management of the items and they're stats
//==========================================================

//==========================================================
// Requires scripts:
// NONE
//==========================================================


//==========================================================
// Variables
//==========================================================
var dirkImage = LoadImage("\Icons\\Final Fantasy VI - Dirk Icon.png");
var swordImage = LoadImage("\Icons\\Final Fantasy VI - Sword Icon.png");
var lanceImage = LoadImage("\Icons\\Final Fantasy VI - Lance Icon.png");
var knifeImage = LoadImage("\Icons\\Final Fantasy VI - Knife Icon.png");
var rodImage = LoadImage("\Icons\\Final Fantasy VI - Rod Icon.png");
var brushImage = LoadImage("\Icons\\Final Fantasy VI - Brush Icon.png");
var starsImage = LoadImage("\Icons\\Final Fantasy VI - Stars Icon.png");
var specialImage = LoadImage("\Icons\\Final Fantasy VI - Special Icon.png");
var gamblerImage = LoadImage("\Icons\\Final Fantasy VI - Gambler Icon.png");
var clawImage = LoadImage("\Icons\\Final Fantasy VI - Claw Icon.png");
var shieldImage = LoadImage("\Icons\\Final Fantasy VI - Shield Icon.png");
var helmetImage = LoadImage("\Icons\\Final Fantasy VI - Helmet Icon.png");
var armourImage = LoadImage("\Icons\\Final Fantasy VI - Armour Icon.png");
var toolImage = LoadImage("\Icons\\Final Fantasy VI - Tool Icon.png");
var skeanImage = LoadImage("\Icons\\Final Fantasy VI - Skean Icon.png");
var relicImage = LoadImage("\Icons\\Final Fantasy VI - Relic Icon.png");


gameItems = []; // Create array to store the items

function itemObject(name, price, info, menu, save)
{
  this.name = name;
  this.price = price;
  this.info = info;
  this.useInMenu = true;
  this.useOnSavePoint = true;
}

function handItemObject(type, name, price, icon, info, vigor, speed, stamina, magPwr, batPwr, defence, evade, magDef, mBlock)
{
  this.type = type;
  this.name = name;
  this.price = price;
  this.icon = icon;
  this.info = info;
  this.vigor = vigor || 0;
  this.speed = speed || 0;
  this.stamina = stamina || 0;
  this.magPwr = magPwr || 0;
  this.batPwr = batPwr || 0;
  this.defence = defence || 0;
  this.evade = evade || 0;
  this.magDef = magDef || 0;
  this.mBlock = mBlock || 0;
}

function headItemObject(name, price, info, vigor, speed, stamina, magPwr, batPwr, defence, evade, magDef, mBlock)
{
  this.type = "HELMET";
  this.name = name;
  this.price = price;
  this.icon = helmetImage;
  this.info = info;
  this.vigor = vigor || 0;
  this.speed = speed || 0;
  this.stamina = stamina || 0;
  this.magPwr = magPwr || 0;
  this.batPwr = batPwr || 0;
  this.defence = defence || 0;
  this.evade = evade || 0;
  this.magDef = magDef || 0;
  this.mBlock = mBlock || 0;
}

function bodyItemObject(name, price, info, vigor, speed, stamina, magPwr, batPwr, defence, evade, magDef, mBlock)
{
  this.type = "ARMOR";
  this.name = name;
  this.price = price;
  this.icon = armourImage;
  this.info = info;
  this.vigor = vigor || 0;
  this.speed = speed || 0;
  this.stamina = stamina || 0;
  this.magPwr = magPwr || 0;
  this.batPwr = batPwr || 0;
  this.defence = defence || 0;
  this.evade = evade || 0;
  this.magDef = magDef || 0;
  this.mBlock = mBlock || 0;
}

function relicItemObject(name, price, info, vigor, speed, stamina, magPwr, batPwr, defence, evade, magDef, mBlock)
{
  this.type = "RELIC";
  this.name = name;
  this.price = price;
  this.icon = relicImage;
  this.info = info;
  this.vigor = vigor || 0;
  this.speed = speed || 0;
  this.stamina = stamina || 0;
  this.magPwr = magPwr || 0;
  this.batPwr = batPwr || 0;
  this.defence = defence || 0;
  this.evade = evade || 0;
  this.magDef = magDef || 0;
  this.mBlock = mBlock || 0;
}

//==========================================================
// ITEMS
//==========================================================
{
  gameItems[0] = new itemObject("Rename Card", 0, "Secret Item");
  gameItems[1] = new itemObject("Tonic", 50, "Recovers 50 HP");
  gameItems[2] = new itemObject("Potion", 300, "Recovers 250 HP");
  gameItems[3] = new itemObject("X-Potion", 2, "Recovers HP to 100%");
  gameItems[4] = new itemObject("Tincture", 1500, "Recovers 50 MP");
  gameItems[5] = new itemObject("Ether", 2, "Recovers 150 MP");
  gameItems[6] = new itemObject("X-Ether", 2, "Recovers MP to 100%");
  gameItems[7] = new itemObject("Elixer", 2, "Recovers HP/MP to 100%");
  gameItems[8] = new itemObject("Megalixir", 2, "Recovers party's HP/MP to 100%");
  gameItems[9] = new itemObject("Phoenix Down", 500, "Recovers the wounded");
  gameItems[10] = new itemObject("Revivify", 300, "Cures \223Zombie\224 status");
  gameItems[11] = new itemObject("Antidote", 50, "Cures \223Poison\224 status");
  gameItems[12] = new itemObject("Eyedrop", 50, "Cures \223Dark\224 status");
  gameItems[13] = new itemObject("Soft", 200, "Cures \223Petrify\224 status");
  gameItems[14] = new itemObject("Remedy", 1000, "Cures status ailments except \223Zombie\224");
  gameItems[15] = new itemObject("Sleeping Bag", 500, "Recovers HP/MP to 100%");
  gameItems[16] = new itemObject("Tent", 1200, "Recovers party's HP/MP to 100%");
  gameItems[17] = new itemObject("Green Cherry", 150, "Cures \223Imp\224 status");
  gameItems[18] = new itemObject("Magicite", 2, "Summons random Esper");
  gameItems[19] = new itemObject("Super Ball", 10000, "Bounding dammage");
  gameItems[20] = new itemObject("Echo Screen", 120, "Cures \223Mute\224 status");
  gameItems[21] = new itemObject("Smoke Bomb", 300, "Lets party escape from battle");
  gameItems[22] = new itemObject("Warp Stone", 700, "Same effect as Warp");
  gameItems[23] = new itemObject("Dried Meat", 150, "Eat when hungry");
}

//==========================================================
// WEAPONS
//==========================================================
{
  //==========================================================
  // DIRK
  //==========================================================
  {
    //==========================================================
    // Item 10
    //==========================================================
    // You can put gameItems["Anything you want / or a number"]
    // You can also have as many as you want as long as the above is different in each
    //==========================================================
    gameItems[24] = new handItemObject("DIRK", "Dirk", 150, dirkImage, undefined, 0, 0, 0, 0, 26);
    gameItems[24].equip = [0, 1, 2, 4, 8, 9, 7, 10, 11, 13];
    
    gameItems[25] = new handItemObject("DIRK", "MithrilKnife", 300, dirkImage, undefined, 0, 0, 0, 0, 59);
    gameItems[25].equip = [0, 1, 2, 4, 7, 8, 9, 10, 11, 13];
    
    gameItems[26] = new handItemObject("DIRK", "Guardian", 2, dirkImage, "Randomly evades an enemy's attack", 0, 4, 0, 0, 59, 0, 10);
    gameItems[26].equip = [1];
    
    gameItems[27] = new handItemObject("DIRK", "Air Lancet", 950, dirkImage, "Wind-elemental", 0, 0, 0, 0, 76);
    gameItems[27].equip = [1, 8, 9, 13];
    
    gameItems[28] = new handItemObject("DIRK", "Theif Knife", 2, dirkImage, "Randomly Steals an enemy's item", 0, 0, 0, 0, 76);
    gameItems[28].equip = [1, 10];
    
    gameItems[29] = new handItemObject("DIRK", "Assassin", 2, dirkImage, "Randomly dispatches an enemy", 0, 3, 0, 2, 106, 0, 10);
    gameItems[29].equip = [1, 10];
    
    gameItems[30] = new handItemObject("DIRK", "Man Eater", 11000, dirkImage, "Doubles damage to human target", 0, 0, 0, 0, 146);
    gameItems[30].equip = [0, 1, 2, 4, 7, 8, 9, 10, 13];
    
    gameItems[31] = new handItemObject("DIRK", "SwordBreaker", 16000, dirkImage, "Randomly evade an enemy's attack", 0, 0, 0, 0, 164, 0, 30);
    gameItems[31].equip = [1, 8, 9, 10, 13];
    
    gameItems[32] = new handItemObject("DIRK", "Graedus", 2, dirkImage, "Pearl-elemental", 0, 0, 0, 0, 204, 0, 10);
    gameItems[32].equip = [0, 1, 2, 4, 7, 8, 9, 10, 11, 13];
    
    gameItems[33] = new handItemObject("DIRK", "ValiantKnife", 2, dirkImage, "Gains power as HP decreases", 0, 0, 0, 0, 145, 0, 10);
    gameItems[33].equip = [1];
    
    gameItems[34] = new handItemObject("DIRK", "Imperial", 600, dirkImage, undefined, 0, 0, 0, 0, 82);
    gameItems[34].equip = [10];
    
    gameItems[35] = new handItemObject("DIRK", "Kodachi", 1200, dirkImage, undefined, 0, 0, 0, 0, 93);
    gameItems[35].equip = [10];
    
    gameItems[36] = new handItemObject("DIRK", "Blossom", 3200, dirkImage, undefined, 0, 0, 0, 0, 112);
    gameItems[36].equip = [10];
    
    gameItems[37] = new handItemObject("DIRK", "Hardened", 2, dirkImage, undefined, 0, 0, 0, 0, 121);
    gameItems[37].equip = [10];
    
    gameItems[38] = new handItemObject("DIRK", "Striker", 2, dirkImage, "Randomly dispatches an enemy", 0, 0, 0, 0, 190);
    gameItems[38].equip = [10];
    
    gameItems[39] = new handItemObject("DIRK", "Stunner", 2, dirkImage, "Randomly casts \223Stop\224", 0, 0, 0, 0, 220);
    gameItems[39].equip = [10];
  }
  //==========================================================
  // SWORD
  //==========================================================
  {
    gameItems[40] = new handItemObject("SWORD", "MithrilBlade", 450, swordImage, undefined, 0, 0, 0, 0, 38);
    gameItems[40].equip = [0, 1, 2, 4];
    
    gameItems[41] = new handItemObject("SWORD", "RegalCutlass", 800, swordImage, undefined, 0, 0, 0, 0, 54);
    gameItems[41].equip = [0, 2, 4];
    
    gameItems[42] = new handItemObject("SWORD", "Rune Edge", 7500, swordImage, "Consumes MP to inflict mortal blow", 0, 0, 0, 0, 55);
    gameItems[42].equip = [0, 2, 4];
    
    gameItems[43] = new handItemObject("SWORD", "Flame Saber", 7000, swordImage, "Randomly casts \223Fire\224", 0, 0, 0, 2, 108);
    gameItems[43].equip = [0, 1, 2, 4];
    
    gameItems[44] = new handItemObject("SWORD", "Blizzard", 7000, swordImage, "Randomly casts \223Ice\224", 0, 0, 0, 2, 108);
    gameItems[44].equip = [0, 1, 2, 4];
    
    gameItems[45] = new handItemObject("SWORD", "ThunderBlade", 7000, swordImage, "Randomly casts \223Bolt\224", 0, 0, 0, 2, 108);
    gameItems[45].equip = [0, 1, 2, 4];
    
    gameItems[46] = new handItemObject("SWORD", "Epee", 3000, swordImage, undefined, 0, 0, 0, 0, 98);
    gameItems[46].equip = [0, 2, 4];
    
    gameItems[47] = new handItemObject("SWORD", "Break Blade", 12000, swordImage, "Randomly casts \223Break\224", 0, 0, 0, 0, 117);
    gameItems[47].equip = [0, 2, 4];
    
    gameItems[48] = new handItemObject("SWORD", "Drainer", 2, swordImage, "Absorbs damage as HP", 0, 0, 0, 0, 121, 0, 10);
    gameItems[48].equip = [0, 1, 2, 4];
    
    gameItems[49] = new handItemObject("SWORD", "Enhancer", 10000, swordImage, "Magic Power up", 0, 0, 0, 7, 135, 0, 0, 0, 20);
    gameItems[49].equip = [0, 2, 4];
    
    gameItems[50] = new handItemObject("SWORD", "Crystal", 15000, swordImage, undefined, 0, 0, 0, 0, 167);
    gameItems[50].equip = [0, 2, 4];
    
    gameItems[51] = new handItemObject("SWORD", "Falchion", 17000, swordImage, undefined, 0, 0, 0, 0, 176, 0, 10);
    gameItems[51].equip = [0, 1, 2, 4];
    
    gameItems[52] = new handItemObject("SWORD", "Soul Saber", 2, swordImage, "Absorbs damage as MP\nRandomly casts \223Doom\224", 0, 0, 0, 0, 125, 0, 10);
    gameItems[52].equip = [0, 1, 2, 4];
    
    gameItems[53] = new handItemObject("SWORD", "Ogre Nix", 2, swordImage, "Uses MP to inflict mortal blow\nMay break if luck is bad", 0, 0, 0, 0, 182);
    gameItems[53].equip = [0, 1, 2, 4];
    
    gameItems[54] = new handItemObject("SWORD", "Excalibur", 2, swordImage, "Pearl-elemental sword", 2, 2, 1, 1, 217, 0, 20);
    gameItems[54].equip = [0, 1, 2, 4];
    
    gameItems[55] = new handItemObject("SWORD", "Scimitar", 2, swordImage, "Randomly dices up an enemy", 0, 0, 0, 0, 208);
    gameItems[55].equip = [0, 5, 2, 4];
    
    gameItems[56] = new handItemObject("SWORD", "Illumina", 2, swordImage, "A legendary sword", 7, 7, 7, 7, 255, 0, 50, 0, 50);
    gameItems[56].equip = [0, 1, 2, 4];
    
    gameItems[57] = new handItemObject("SWORD", "Ragnarok", 2, swordImage, "Randomly casts \223Flare\224", 7, 3, 7, 7, 255, 0, 30, 0, 30);
    gameItems[57].equip = [0, 1, 2, 4];
    
    gameItems[58] = new handItemObject("SWORD", "AtmaWeapon", 2, swordImage, "Transforms at Level UP\nGrows stronger as HP increases", 0, 0, 0, 0, 255);
    gameItems[58].equip = [0, 1, 2, 4];
  }
  //==========================================================
  // LANCE
  //==========================================================
  {
    gameItems[59] = new handItemObject("LANCE", "Mithril Pike", 800, lanceImage, undefined, 0, 0, 0, 0, 70);
    gameItems[59].equip = [2, 11];
    
    gameItems[60] = new handItemObject("LANCE", "Trident", 1700, lanceImage, undefined, 0, 0, 0, 0, 93);
    gameItems[60].equip = [2, 11];
    
    gameItems[61] = new handItemObject("LANCE", "Stout Spear", 10000, lanceImage, undefined, 0, 0, 0, 0, 112);
    gameItems[61].equip = [2, 11];
    
    gameItems[62] = new handItemObject("LANCE", "Partisan", 13000, lanceImage, undefined, 0, 0, 0, 0, 150);
    gameItems[62].equip = [2, 11];
    
    gameItems[63] = new handItemObject("LANCE", "Pearl Lance", 2, lanceImage, "Randomly casts \223Pearl\224", 0, 0, 0, 3, 194);
    gameItems[63].equip = [2, 11];
    
    gameItems[64] = new handItemObject("LANCE", "Gold Lance", 12000, lanceImage, undefined, 0, 0, 0, 0, 139);
    gameItems[64].equip = [2, 11];
    
    gameItems[65] = new handItemObject("LANCE", "Aura Lance", 2, lanceImage, undefined, 3, 2, 1, 3, 227);
    gameItems[65].equip = [2, 11];
    
    gameItems[66] = new handItemObject("LANCE", "Imp Halberd", 2, lanceImage, "??? if equipped while Imp", 0, 0, 0, 0, 253);
    gameItems[66].equip = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13];
  }
  //==========================================================
  // KNIFE
  //==========================================================
  {
    gameItems[67] = new handItemObject("KNIFE", "Ashura", 500, knifeImage, undefined, 0, 0, 0, 0, 57);
    gameItems[67].equip = [5];
    
    gameItems[68] = new handItemObject("KNIFE", "Kotetsu", 800, knifeImage, undefined, 0, 0, 0, 0, 66);
    gameItems[68].equip = [5];
    
    gameItems[69] = new handItemObject("KNIFE", "Forged", 1200, knifeImage, undefined, 0, 0, 0, 0, 81);
    gameItems[69].equip = [5];
    
    gameItems[70] = new handItemObject("KNIFE", "Tempest", 8000, knifeImage, "Randomly casts \223Wind Slash\224", 0, 0, 0, 0, 101);
    gameItems[70].equip = [5];
    
    gameItems[71] = new handItemObject("KNIFE", "Murasame", 9000, knifeImage, undefined, 0, 0, 0, 0, 110);
    gameItems[71].equip = [5];
    
    gameItems[72] = new handItemObject("KNIFE", "Aura", 2, knifeImage, undefined, 0, 0, 0, 0, 162);
    gameItems[72].equip = [5];
    
    gameItems[73] = new handItemObject("KNIFE", "Strato", 2, knifeImage, undefined, 0, 0, 0, 0, 199);
    gameItems[73].equip = [5];
    
    gameItems[74] = new handItemObject("KNIFE", "Sky Render", 2, knifeImage, undefined, 0, 0, 0, 0, 215, 0, 20);
    gameItems[74].equip = [5];
  }
  //==========================================================
  // ROD
  //==========================================================
  {
    gameItems[75] = new handItemObject("ROD", "Heal Rod", 2, rodImage, "Recovers target's HP", 0, 0, 0, 0, 200);
    gameItems[75].equip = [8, 9, 13];
    
    gameItems[76] = new handItemObject("ROD", "Mithril Rod", 500, rodImage, undefined, 0, 0, 0, 2, 60);
    gameItems[76].equip = [8, 9, 13];
    
    gameItems[77] = new handItemObject("ROD", "Fire Rod", 3000, rodImage, "Casts \223Fire 2\224 as an item and breaks", 0, 0, 0, 0, 79);
    gameItems[77].equip = [8, 9, 13];
    
    gameItems[78] = new handItemObject("ROD", "Ice Rod", 3000, rodImage, "Casts \223Ice 2\224 as an item and breaks", 0, 0, 0, 0, 79);
    gameItems[78].equip = [8, 9, 13];
    
    gameItems[79] = new handItemObject("ROD", "Thunder Rod", 3000, rodImage, "Casrs \223Bolt 2\224 as an item and breaks", 0, 0, 0, 0, 79);
    gameItems[79].equip = [8, 9, 13];
    
    gameItems[80] = new handItemObject("ROD", "Poison Rod", 1500, rodImage, "Casts \223Poison\224 as an item and breaks", 0, 0, 0, 0, 86);
    gameItems[80].equip = [8, 9, 13];
    
    gameItems[81] = new handItemObject("ROD", "Pearl Rod", 12000, rodImage, "Casts \223Pearl\224 as an item and breaks", 0, 0, 0, 0, 124);
    gameItems[81].equip = [8, 9, 13];
    
    gameItems[82] = new handItemObject("ROD", "Gravity Rod", 13000, rodImage, "Casts \223Quarter\224 as an item and breaks", 0, 0, 0, 0, 120);
    gameItems[82].equip = [8, 9, 13];
    
    gameItems[83] = new handItemObject("ROD", "Punisher", 2, rodImage, "Uses MP to inflict mortal blow", 0, 0, 0, 0, 111);
    gameItems[83].equip = [8, 9, 13];
    
    gameItems[84] = new handItemObject("ROD", "Magus Rod", 2, rodImage, "Magic Power up", 0, 0, 0, 7, 168, 0, 0, 0, 30);
    gameItems[84].equip = [8, 9, 13];
  }
  //==========================================================
  // BRUSH
  //==========================================================
  {
    gameItems[85] = new handItemObject("BRUSH", "ChocoboBrush", 600, brushImage, undefined, 0, 0, 0, 1, 60);
    gameItems[85].equip = [9];
    
    gameItems[86] = new handItemObject("BRUSH", "DaVinciBrush", 7000, brushImage, undefined, 0, 1, 0, 1, 100);
    gameItems[86].equip = [9];
    
    gameItems[87] = new handItemObject("BRUSH", "MagicalBrush", 10000, brushImage, undefined, 0, 1, 1, 1, 130);
    gameItems[87].equip = [9];
    
    gameItems[88] = new handItemObject("BRUSH", "RainbowBrush", 2, brushImage, undefined, 1, 2, 1, 2, 146);
    gameItems[88].equip = [9];
  }
  //==========================================================
  // STARS
  //==========================================================
  {
    //==========================================================
    // Item 10
    //==========================================================
    // You can put gameItems["Anything you want / or a number"]
    // You can also have as many as you want as long as the above is different in each
    //==========================================================
    gameItems[89] = new Object;
    gameItems[89].name = "Shuriken"; // Item name
    gameItems[89].type = "STARS"; // Item type
    gameItems[89].icon = starsImage
    gameItems[89].info = "Use with \223Throw\224 command"
    gameItems[89].price = 30
    gameItems[89].vigor = 0
    gameItems[89].speed = 0
    gameItems[89].stamina = 0
    gameItems[89].magpwr = 0
    gameItems[89].batpwr = 86
    gameItems[89].defense = 0
    gameItems[89].evade = 0
    gameItems[89].magdef = 0
    gameItems[89].mblock = 0
    //==========================================================
    // Item 10
    //==========================================================
    // You can put gameItems["Anything you want / or a number"]
    // You can also have as many as you want as long as the above is different in each
    //==========================================================
    gameItems[90] = new Object;
    gameItems[90].name = "Ninja Star"; // Item name
    gameItems[90].type = "STARS"; // Item type
    gameItems[90].icon = starsImage
    gameItems[90].info = "Use with \223Throw\224 command"
    gameItems[90].price = 500
    gameItems[90].vigor = 0
    gameItems[90].speed = 0
    gameItems[90].stamina = 0
    gameItems[90].magpwr = 0
    gameItems[90].batpwr = 132
    gameItems[90].defense = 0
    gameItems[90].evade = 0
    gameItems[90].magdef = 0
    gameItems[90].mblock = 0
    //==========================================================
    // Item 10
    //==========================================================
    // You can put gameItems["Anything you want / or a number"]
    // You can also have as many as you want as long as the above is different in each
    //==========================================================
    gameItems[91] = new Object;
    gameItems[91].name = "Tack Star"; // Item name
    gameItems[91].type = "STARS"; // Item type
    gameItems[91].icon = starsImage
    gameItems[91].info = "Use with \223Throw\224 command"
    gameItems[91].price = 2
    gameItems[91].vigor = 0
    gameItems[91].speed = 0
    gameItems[91].stamina = 0
    gameItems[91].magpwr = 0
    gameItems[91].batpwr = 190
    gameItems[91].defense = 0
    gameItems[91].evade = 0
    gameItems[91].magdef = 0
    gameItems[91].mblock = 0
  }
  //==========================================================
  // SPECIAL
  //==========================================================
  {
    gameItems[92] = new handItemObject("SPECIAL", "Flail", 2000, specialImage, "Same damage from back row", 0, 0, 0, 0, 86);
    gameItems[92].equip = [0, 4, 8, 9, 13];
    
    gameItems[93] = new handItemObject("SPECIAL", "Full Moon", 2500, specialImage, "Same damage from back row", 0, 0, 0, 0, 95);
    gameItems[93].equip = [1];
    
    gameItems[94] = new handItemObject("SPECIAL", "Morning Star", 5000, specialImage, "Same damage from back row", 0, 0, 0, 0, 109);
    gameItems[94].equip = [0, 4, 8, 9, 13];
    
    gameItems[95] = new handItemObject("SPECIAL", "Boomerang", 4500, specialImage, "Same damage from back row", 0, 0, 0, 0, 102);
    gameItems[95].equip = [1];
    
    gameItems[96] = new handItemObject("SPECIAL", "Rising Sun", 2, specialImage, "Same damage from back row", 0, 0, 0, 0, 117);
    gameItems[96].equip = [1];
    
    gameItems[97] = new handItemObject("SPECIAL", "Hawk Eye", 6000, specialImage, "Same damage from back row", 0, 0, 0, 0, 111);
    gameItems[97].equip = [1];
    
    gameItems[98] = new handItemObject("SPECIAL", "Bone Club", 20000, specialImage, "Intricatly carved", 0, 0, 0, 0, 151);
    gameItems[98].equip = [12];
    
    gameItems[99] = new handItemObject("SPECIAL", "Sniper", 15000, specialImage, "Same damage from back row", 0, 0, 0, 0, 172);
    gameItems[99].equip = [1];
    
    gameItems[100] = new handItemObject("SPECIAL", "Wing Edge", 2, specialImage, "Same damage from back row\nRandomly strikes mortal blow", 7, 7, 1, 2, 198);
    gameItems[100].equip = [1];
  }
  //==========================================================
  // GAMBLER
  //==========================================================
  {
    gameItems[101] = new handItemObject("GAMBLER", "Cards", 1000, gamblerImage, undefined, 0, 0, 0, 0, 104);
    gameItems[101].equip = [7];
    
    gameItems[102] = new handItemObject("GAMBLER", "Darts", 10000, gamblerImage, undefined, 0, 0, 0, 0, 115);
    gameItems[102].equip = [7];
    
    gameItems[103] = new handItemObject("GAMBLER", "Doom Darts", 2, gamblerImage, "Randomly casts \223Doom\224", 0, 0, 0, 0, 187);
    gameItems[103].equip = [7];
    
    gameItems[104] = new handItemObject("GAMBLER", "Trump", 13000, gamblerImage, "Randomly dispatches an enemy", 0, 0, 0, 0, 133);
    gameItems[104].equip = [7];
    
    gameItems[105] = new handItemObject("GAMBLER", "Dice", 5000, gamblerImage, undefined, 0, 0, 0, 0, 1);
    gameItems[105].equip = [7];
    
    gameItems[106] = new handItemObject("GAMBLER", "Fixed Dice", 2, gamblerImage, undefined, 0, 0, 0, 0, 1);
    gameItems[106].equip = [7];
  }
  //==========================================================
  // CLAW
  //==========================================================
  {
    gameItems[107] = new handItemObject("CLAW", "MetalKnuckle", 500, clawImage, undefined, 0, 0, 0, 0, 55);
    gameItems[107].equip = [3];
    
    gameItems[108] = new handItemObject("CLAW", "Mithril Claw", 800, clawImage, undefined, 0, 0, 0, 0, 65);
    gameItems[108].equip = [3];
    
    gameItems[109] = new handItemObject("CLAW", "Kaiser", 1000, clawImage, undefined, 0, 0, 0, 0, 83);
    gameItems[109].equip = [3];
    
    gameItems[110] = new handItemObject("CLAW", "Poison Claw", 2500, clawImage, "Randomly poisons an enemy", 0, 0, 0, 0, 95);
    gameItems[110].equip = [3];
    
    gameItems[111] = new handItemObject("CLAW", "Fire Knuckle", 10000, clawImage, "Randomly casts \223Fire\224", 0, 0, 0, 0, 122);
    gameItems[111].equip = [3];
    
    gameItems[112] = new handItemObject("CLAW", "Dragon Claw", 2, clawImage, "Pearl-elemental", 2, 0, 0, 1, 188);
    gameItems[112].equip = [3];
    
    gameItems[113] = new handItemObject("CLAW", "Tiger Fangs", 2, clawImage, undefined, 3, 2, 2, 3, 215);
    gameItems[113].equip = [3];
  }
}
//==========================================================
// SHEILD
//==========================================================
{
  gameItems[114] = new handItemObject("SHIELD", "Buckler", 200, shieldImage, undefined, 0, 0, 0, 0, 0, 16);
  gameItems[114].equip = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13];
  
  gameItems[115] = new handItemObject("SHIELD", "Heavy Shld", 400, shieldImage, undefined, 0, 0, 0, 0, 0, 22, 10, 14);
  gameItems[115].equip = [0, 1, 2, 4, 5, 7];
  
  gameItems[116] = new handItemObject("SHIELD", "Mithril Shld", 1200, shieldImage, undefined, 0, 0, 0, 0, 0, 27, 10, 18);
  gameItems[116].equip = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13];
  
  gameItems[117] = new handItemObject("SHIELD", "Gold Shld", 2500, shieldImage, undefined, 0, 0, 0, 0, 0, 34, 10, 23);
  gameItems[117].equip = [0, 2, 4, 5, 7, 11];
  
  gameItems[118] = new handItemObject("SHIELD", "Aegis Shld", 2, shieldImage, "Randomly evades magic attack", 0, 0, 60, 0, 0, 46, 20, 52, 40);
  gameItems[118].equip = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13];
  
  gameItems[119] = new handItemObject("SHIELD", "Diamond Shld", 3500, shieldImage, undefined, 0, 0, 0, 0, 0, 40, 10, 27);
  gameItems[119].equip = [0, 2, 4, 5, 7];
  
  gameItems[120] = new handItemObject("SHIELD", "Flame Shld", 2, shieldImage, "Absorbs Fire-elemental attack", 0, 0, 0, 0, 0, 41, 20, 28, 10);
  gameItems[120].equip = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13];
  
  gameItems[121] = new handItemObject("SHIELD", "Ice Shld", 2, shieldImage, "Absorbs Ice-elemental", 0, 0, 0, 0, 0, 42, 20, 28, 10);
  gameItems[121].equip = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13];
  
  gameItems[122] = new handItemObject("SHIELD", "Thunder Shld", 2, shieldImage, "Absorbs Thunder-elemental attack", 0, 0, 0, 0, 0, 43, 20, 28, 10);
  gameItems[122].equip = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13];
  
  gameItems[123] = new handItemObject("SHIELD", "Crystal Shld", 7000, shieldImage, undefined, 0, 0, 0, 0, 0, 50, 10, 34);
  gameItems[123].equip = [0, 2, 4, 5, 7];
  
  gameItems[124] = new handItemObject("SHIELD", "Genji Shld", 2, shieldImage, undefined, 0, 0, 0, 0, 0, 54, 20, 50, 20);
  gameItems[124].equip = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13];
  
  gameItems[125] = new handItemObject("SHIELD", "TortoiseShld", 2, shieldImage, "??? if equipped while an Imp", 0, 0, 0, 0, 0, 66, 30, 66, 30);
  gameItems[125].equip = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13];
  
  gameItems[126] = new handItemObject("SHIELD", "Cursed Shld", 2, shieldImage, "Is cursed");
  gameItems[126].equip = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13];
  
  gameItems[127] = new handItemObject("SHIELD", "Paladin Shld", 2, shieldImage, "Houses a hero's soul");
  gameItems[127].equip = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13];
  
  gameItems[128] = new handItemObject("SHIELD", "Force Shld", 2, shieldImage, "Protects against magic attacks");
  gameItems[128].equip = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13];
}
//==========================================================
// HELMET
//==========================================================
{
  gameItems[129] = new headItemObject("Leather Hat", 50, undefined, 0, 0, 0, 0, 0, 11, 0, 7);
  gameItems[129].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4];
  
  gameItems[130] = new headItemObject("Hair Band", 150, undefined, 0, 0, 0, 0, 0, 12, 0, 8);
  gameItems[130].equip = [0, 4, 9];
  
  gameItems[131] = new headItemObject("Plumed Hat", 250, undefined, 0, 0, 0, 0, 0, 14, 0, 9);
  gameItems[131].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4];
  
  gameItems[132] = new headItemObject("Beret", 3500, "Raises success rate of \223Sketch\224", 0, 0, 0, 0, 0, 21, 0, 21);
  gameItems[132].equip = [9];
  
  gameItems[133] = new headItemObject("Magus Hat", 600, undefined, 0, 0, 0, 5, 0, 15, 0, 16);
  gameItems[133].equip = [0, 4, 8, 9, 11, 13];
  
  gameItems[134] = new headItemObject("Bandana", 800, undefined, 0, 0, 0, 0, 0, 16);
  gameItems[134].equip = [0, 1, 3, 4, 9, 6];
  
  gameItems[135] = new headItemObject("Iron Helmet", 1000, undefined, 0, 0, 0, 0, 0, 18, 0, 12);
  gameItems[135].equip = [0, 1, 5, 2, 4, 7, 6];
  
  gameItems[136] = new headItemObject("Coronet", 2, "Raises success rate of \223Control\224", 0, 0, 0, 4, 0, 23, 0, 23);
  gameItems[136].equip = [9];
  
  gameItems[137] = new headItemObject("Bard's Hat", 3000, "Raises MP a little", 0, 0, 0, 0, 0, 19, 0, 21, 10);
  gameItems[137].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4];
  
  gameItems[138] = new headItemObject("Green Beret", 3000, "Raises HP a little", 0, 0, 0, 0, 0, 19, 10, 13);
  gameItems[138].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4];
  
  gameItems[139] = new headItemObject("Head Band", 1600, undefined, 3, 1, 2, 0, 0, 16, 0, 10);
  gameItems[139].equip = [1, 5, 10, 3, 11, 6];
  
  gameItems[140] = new headItemObject("Mithril Helm", 2000, undefined, 0, 0, 0, 0, 0, 20, 0, 13);
  gameItems[140].equip = [0, 1, 5, 2, 10, 4, 7, 6, 13];
  
  gameItems[141] = new headItemObject("Tiara", 3000, undefined, 0, 0, 0, 2, 0, 22, 0, 20);
  gameItems[141].equip = [0, 4, 9];
  
  gameItems[142] = new headItemObject("Gold Helmet", 4000, undefined, 0, 0, 0, 0, 0, 22, 0, 15);
  gameItems[142].equip = [0, 2, 4, 11];
  
  gameItems[143] = new headItemObject("Tiger Mask", 2500, undefined, 3, 2, 1, 0, 0, 21, 0, 13);
  gameItems[143].equip = [3, 6];
  
  gameItems[144] = new headItemObject("Red Cap", 2, "Raises HP by 1/4", 4, 3, 2, 0, 0, 24, 0, 17);
  gameItems[144].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4];
  
  gameItems[145] = new headItemObject("Mystery Veil", 5500, undefined, 0, 1, 0, 3, 0, 24, 0, 25, 10);
  gameItems[145].equip = [0, 4, 9];
  
  gameItems[146] = new headItemObject("Circlet", 7000, undefined, 2, 1, 3, 4, 0, 25, 0, 19);
  gameItems[146].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4];
  
  gameItems[147] = new headItemObject("Regal Crown", 2, undefined, 1, 1, 1, 1, 0, 28, 0, 23);
  gameItems[147].equip = [2, 3];
  
  gameItems[148] = new headItemObject("Diamond Helm", 8000, undefined, 0, 0, 0, 0, 0, 27, 0, 18);
  gameItems[148].equip = [0, 5, 2, 4, 7];
  
  gameItems[149] = new headItemObject("Dark Hood", 7500, undefined, 0, 0, 0, 0, 0, 26, 0, 17);
  gameItems[149].equip = [1, 3, 10, 11, 6, 13];
  
  gameItems[150] = new headItemObject("Crystal Helm", 10000, undefined, 0, 0, 0, 0, 0, 29, 0, 19);
  gameItems[150].equip = [0, 2, 4, 7];
  
  gameItems[151] = new headItemObject("Oath Veil", 9000, undefined, 0, 0, 0, 0, 0, 32, 0, 31);
  gameItems[151].equip = [0, 4, 9];
  
  gameItems[152] = new headItemObject("Cat Hood", 2, "Picks up all possible GP", 0, 2, 0, 4, 0, 33, 0, 33);
  gameItems[152].equip = [9];
  
  gameItems[153] = new headItemObject("Genji Helmet", 2, undefined, 0, 0, 0, 0, 0, 36, 0, 38);
  gameItems[153].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4];
  
  gameItems[154] = new headItemObject("Thornlet", 2, "Thorn inflicts pain", 0, 0, 0, 0, 0, 38);
  gameItems[154].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4];
  
  gameItems[155] = new headItemObject("Titanium", 2, "??? if equipped while an Imp", 0, 0, 0, 0, 0, 42, 0, 42);
  gameItems[155].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4];
}
//==========================================================
// ARMOUR
//==========================================================
{
  gameItems[156] = new bodyItemObject("LeatherArmor", 150, undefined, 0, 0, 0, 0, 0, 28, 0, 19);
  gameItems[156].equip = [0, 1, 5, 10, 2, 4, 8, 9, 7, 11, 6, 13];
  
  gameItems[157] = new bodyItemObject("Cotton Robe", 200, undefined, 0, 0, 0, 0, 0, 32, 0, 21);
  gameItems[157].equip = [0, 8, 9, 13];
  
  gameItems[158] = new bodyItemObject("Kung Fu Suit", 250, undefined, 0, 0, 0, 0, 0, 34, 0, 23);
  gameItems[158].equip = [1, 10, 3, 6];
  
  gameItems[159] = new bodyItemObject("Iron Armor", 700, undefined, 0, -2, 0, 0, 0, 40, 0, 27);
  gameItems[159].equip = [0, 1, 5, 2, 4, 7];
  
  gameItems[160] = new bodyItemObject("Silk Robe", 600, undefined, 0, 0, 0, 1, 0, 39, 0, 29);
  gameItems[160].equip = [0, 4, 8, 9, 11, 13];
  
  gameItems[161] = new bodyItemObject("Mithril Vest", 1200, undefined, 0, 0, 0, 0, 0, 45, 0, 30);
  gameItems[161].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4];
  
  gameItems[162] = new bodyItemObject("Ninja Gear", 1100, undefined, 0, 2, 0, 0, 0, 47, 0, 32);
  gameItems[162].equip = [1, 10, 3, 7, 6, 13];
  
  gameItems[163] = new bodyItemObject("White Dress", 2200, undefined, 0, 0, 0, 5, 0, 47, 0, 35);
  gameItems[163].equip = [0, 4, 9];
  
  gameItems[164] = new bodyItemObject("Mithril Mail", 3500, undefined, 0, 0, 0, 0, 0, 51, 0, 34);
  gameItems[164].equip = [0, 1, 5, 2, 4, 7];
  
  gameItems[165] = new bodyItemObject("Gaia Gear", 6000, "Absorbs Earth-elemental attack", 0, 0, 0, 0, 0, 53, 0, 43);
  gameItems[165].equip = [0, 1, 10, 3, 4, 8, 9, 7, 11, 6, 13];
  
  gameItems[166] = new bodyItemObject("Mirage Vest", 2, "Creates illusion of wearer", 0, 6, 0, 0, 0, 48, 0, 36, 10);
  gameItems[166].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4];
  
  gameItems[167] = new bodyItemObject("Gold Armor", 10000, undefined, 0, 0, 0, 0, 0, 55, 0, 37);
  gameItems[167].equip = [0, 5, 2, 4, 7, 11];
  
  gameItems[168] = new bodyItemObject("Power Sash", 5000, undefined, 5, 1, 5, 0, 0, 52, 0, 35);
  gameItems[168].equip = [1, 5, 10, 3, 6];
  
  gameItems[169] = new bodyItemObject("Light Robe", 11000, undefined, 0, 0, 0, 2, 0, 60, 0, 43);
  gameItems[169].equip = [8, 9, 13];
  
  gameItems[170] = new bodyItemObject("Diamond Vest", 12000, undefined, 0, 0, 0, 0, 0, 65, 0, 44);
  gameItems[170].equip = [0, 1, 5, 10, 2, 3, 4, 7, 11, 6, 13];
  
  gameItems[171] = new bodyItemObject("Red Jacket", 2, "Houses legendary grappler's spirit", 5, 2, 4, 1, 0, 78, 0, 55);
  gameItems[171].equip = [2, 3];
  
  gameItems[172] = new bodyItemObject("Force Armor", 2, "Magic Defence up", 0, 0, 0, 0, 0, 69, 0, 68, 30);
  gameItems[172].equip = [0, 1, 5, 2, 4, 7];
  
  gameItems[173] = new bodyItemObject("DiamondArmor", 15000, undefined, 0, 0, 0, 0, 0, 70, 0, 47);
  gameItems[173].equip = [0, 5, 2, 4, 7];
  
  gameItems[174] = new bodyItemObject("Dark Gear", 13000, undefined, 0, 6, 0, 0, 0, 68, 0, 46);
  gameItems[174].equip = [1, 10, 3, 7, 6, 13];
  
  gameItems[175] = new bodyItemObject("Tao Robe", 13000, undefined, 0, 0, 0, 5, 0, 68, 0, 50, 10);
  gameItems[175].equip = [8, 9, 13];
  
  gameItems[176] = new bodyItemObject("Crystal Mail", 17000, undefined, 0, 0, 0, 0, 0, 72, 0, 49);
  gameItems[176].equip = [0, 1, 5, 2, 4, 7];
  
  gameItems[177] = new bodyItemObject("Czarina Gown", 2, undefined, 1, 2, 2, 3, 0, 70, 0, 64);
  gameItems[177].equip = [9];
  
  gameItems[178] = new bodyItemObject("Genji Armor", 2, undefined, 5, 3, 2, 3, 0, 90, 0, 80);
  gameItems[178].equip = [0, 1, 5, 10, 4, 2, 7];
  
  gameItems[179] = new bodyItemObject("Imp's Armour", 2, "??? if equipped while an Imp", 0, 0, 0, 0, 0, 100, 0, 100);
  gameItems[179].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4];
  
  gameItems[180] = new bodyItemObject("Minerva", 2, "Raises MP by 1/4", 1, 2, 1, 4, 0, 88, 0, 70, 10);
  gameItems[180].equip = [0, 4];
  
  gameItems[181] = new bodyItemObject("Tabby Suit", 2, "Resembles a tabby cat", 2, 2, 2, 2, 0, 54, 0, 36);
  gameItems[181].equip = [8, 9];
  
  gameItems[182] = new bodyItemObject("Chocobo Suit", 2, "Feel like a chocobo!", 3, 6, 2, 0, 0, 56, 0, 38);
  gameItems[182].equip = [8, 9];
  
  gameItems[183] = new bodyItemObject("Moogle Suit", 2, "Be a moogle! Kupo!!", 0, 0, 0, 5, 0, 58, 0, 52);
  gameItems[183].equip = [8, 9];
  
  gameItems[184] = new bodyItemObject("Nutkin Suit", 2, "A squirel costume", 0, 7, 0, 3, 0, 86, 0, 67);
  gameItems[184].equip = [8, 9];
  
  gameItems[185] = new bodyItemObject("BehemothSuit", 2, "Made of behemoth hide", 6, 6, 6, 6, 0, 94, 0, 73);
  gameItems[185].equip = [8, 9];
  
  gameItems[186] = new bodyItemObject("Snow Muffler", 2, "How cozy!", 0, 0, 0, 0, 0, 128, 10, 90, 10);
  gameItems[186].equip = [11, 6, 12];
}
//==========================================================
// TOOL
//==========================================================
{
//==========================================================
// Item 10
//==========================================================
// You can put gameItems["Anything you want / or a number"]
// You can also have as many as you want as long as the above is different in each
//==========================================================
gameItems[187] = new Object;
gameItems[187].name = "NoiseBlaster"; // Item name
gameItems[187].type = "TOOL"; // Item type
gameItems[187].icon = toolImage
gameItems[187].info = "Confuses multiple enemies\nUse with \223Tools\224 command"
gameItems[187].price = 500
gameItems[187].vigor = 0
gameItems[187].speed = 0
gameItems[187].stamina = 0
gameItems[187].magpwr = 0
gameItems[187].batpwr = 0
gameItems[187].defense = 0
gameItems[187].evade = 0
gameItems[187].magdef = 0
gameItems[187].mblock = 0
//==========================================================
// Item 10
//==========================================================
// You can put gameItems["Anything you want / or a number"]
// You can also have as many as you want as long as the above is different in each
//==========================================================
gameItems[188] = new Object;
gameItems[188].name = "Bio Blaster"; // Item name
gameItems[188].type = "TOOL"; // Item type
gameItems[188].icon = toolImage
gameItems[188].info = "Gasses multiple enemies\nUse with \223Tools\224 command"
gameItems[188].price = 750
gameItems[188].vigor = 0
gameItems[188].speed = 0
gameItems[188].stamina = 0
gameItems[188].magpwr = 0
gameItems[188].batpwr = 0
gameItems[188].defense = 0
gameItems[188].evade = 0
gameItems[188].magdef = 0
gameItems[188].mblock = 0
//==========================================================
// Item 10
//==========================================================
// You can put gameItems["Anything you want / or a number"]
// You can also have as many as you want as long as the above is different in each
//==========================================================
gameItems[189] = new Object;
gameItems[189].name = "Flash"; // Item name
gameItems[189].type = "TOOL"; // Item type
gameItems[189].icon = toolImage
gameItems[189].info = "Blinds multiple enemies\nUse with \223Tools\224 command"
gameItems[189].price = 1000
gameItems[189].vigor = 0
gameItems[189].speed = 0
gameItems[189].stamina = 0
gameItems[189].magpwr = 0
gameItems[189].batpwr = 0
gameItems[189].defense = 0
gameItems[189].evade = 0
gameItems[189].magdef = 0
gameItems[189].mblock = 0
//==========================================================
// Item 10
//==========================================================
// You can put gameItems["Anything you want / or a number"]
// You can also have as many as you want as long as the above is different in each
//==========================================================
gameItems[190] = new Object;
gameItems[190].name = "AutoCrossbow"; // Item name
gameItems[190].type = "TOOL"; // Item type
gameItems[190].icon = toolImage
gameItems[190].info = "Strikes multiple enemies\nUse with \223Tools\224 command"
gameItems[190].price = 250
gameItems[190].vigor = 0
gameItems[190].speed = 0
gameItems[190].stamina = 0
gameItems[190].magpwr = 0
gameItems[190].batpwr = 125
gameItems[190].defense = 0
gameItems[190].evade = 0
gameItems[190].magdef = 0
gameItems[190].mblock = 0
//==========================================================
// Item 10
//==========================================================
// You can put gameItems["Anything you want / or a number"]
// You can also have as many as you want as long as the above is different in each
//==========================================================
gameItems[191] = new Object;
gameItems[191].name = "Debilitator"; // Item name
gameItems[191].type = "TOOL"; // Item type
gameItems[191].icon = toolImage
gameItems[191].info = "Casts weak point randomly\nUse with \223Tools\224 command"
gameItems[191].price = 5000
gameItems[191].vigor = 0
gameItems[191].speed = 0
gameItems[191].stamina = 0
gameItems[191].magpwr = 0
gameItems[191].batpwr = 0
gameItems[191].defense = 0
gameItems[191].evade = 0
gameItems[191].magdef = 0
gameItems[191].mblock = 0
//==========================================================
// Item 10
//==========================================================
// You can put gameItems["Anything you want / or a number"]
// You can also have as many as you want as long as the above is different in each
//==========================================================
gameItems[192] = new Object;
gameItems[192].name = "Drill"; // Item name
gameItems[192].type = "TOOL"; // Item type
gameItems[192].icon = toolImage
gameItems[192].info = "Penetrates an ememy's defence\nUse with \223Tools\224 command"
gameItems[192].price = 3000
gameItems[192].vigor = 0
gameItems[192].speed = 0
gameItems[192].stamina = 0
gameItems[192].magpwr = 0
gameItems[192].batpwr = 191
gameItems[192].defense = 0
gameItems[192].evade = 0
gameItems[192].magdef = 0
gameItems[192].mblock = 0
//==========================================================
// Item 10
//==========================================================
// You can put gameItems["Anything you want / or a number"]
// You can also have as many as you want as long as the above is different in each
//==========================================================
gameItems[193] = new Object;
gameItems[193].name = "Chain Saw"; // Item name
gameItems[193].type = "TOOL"; // Item type
gameItems[193].icon = toolImage
gameItems[193].info = "Randomly dispatches an enemy\nUse with \223Tools\224 command"
gameItems[193].price = 2000
gameItems[193].vigor = 0
gameItems[193].speed = 0
gameItems[193].stamina = 0
gameItems[193].magpwr = 0
gameItems[193].batpwr = 252
gameItems[193].defense = 0
gameItems[193].evade = 0
gameItems[193].magdef = 0
gameItems[193].mblock = 0
//==========================================================
// Item 10
//==========================================================
// You can put gameItems["Anything you want / or a number"]
// You can also have as many as you want as long as the above is different in each
//==========================================================
gameItems[194] = new Object;
gameItems[194].name = "Air Anchor"; // Item name
gameItems[194].type = "TOOL"; // Item type
gameItems[194].icon = toolImage
gameItems[194].info = "Enemy becomes self-destructive\nUse with \223Tools\224 command"
gameItems[194].price = 2
gameItems[194].vigor = 0
gameItems[194].speed = 0
gameItems[194].stamina = 0
gameItems[194].magpwr = 0
gameItems[194].batpwr = 128
gameItems[194].defense = 0
gameItems[194].evade = 0
gameItems[194].magdef = 0
gameItems[194].mblock = 0
}
//==========================================================
// SKEAN
//==========================================================
{
//==========================================================
// Item 10
//==========================================================
// You can put gameItems["Anything you want / or a number"]
// You can also have as many as you want as long as the above is different in each
//==========================================================
gameItems[195] = new Object;
gameItems[195].name = "Fire Skean"; // Item name
gameItems[195].type = "SKEAN"; // Item type
gameItems[195].icon = skeanImage
gameItems[195].info = "Multi Fire-elemental damage\nUse with \223Throw\224 command"
gameItems[195].price = 500
//==========================================================
// Item 10
//==========================================================
// You can put gameItems["Anything you want / or a number"]
// You can also have as many as you want as long as the above is different in each
//==========================================================
gameItems[196] = new Object;
gameItems[196].name = "Water Edge"; // Item name
gameItems[196].type = "SKEAN"; // Item type
gameItems[196].icon = skeanImage
gameItems[196].info = "Multi Water-elemental damage\nUse with \223Throw\224 command"
gameItems[196].price = 500
//==========================================================
// Item 10
//==========================================================
// You can put gameItems["Anything you want / or a number"]
// You can also have as many as you want as long as the above is different in each
//==========================================================
gameItems[197] = new Object;
gameItems[197].name = "Bolt Edge"; // Item name
gameItems[197].type = "SKEAN"; // Item type
gameItems[197].icon = skeanImage
gameItems[197].info = "Multi Thunder-elemental damage\nUse with \223Throw\224 command"
gameItems[197].price = 500
//==========================================================
// Item 10
//==========================================================
// You can put gameItems["Anything you want / or a number"]
// You can also have as many as you want as long as the above is different in each
//==========================================================
gameItems[198] = new Object;
gameItems[198].name = "Inviz Edge"; // Item name
gameItems[198].type = "SKEAN"; // Item type
gameItems[198].icon = skeanImage
gameItems[198].info = "Makes thrower transparent\nUse with \223Throw\224 command"
gameItems[198].price = 200
//==========================================================
// Item 10
//==========================================================
// You can put gameItems["Anything you want / or a number"]
// You can also have as many as you want as long as the above is different in each
//==========================================================
gameItems[199] = new Object;
gameItems[199].name = "10 Edge"; // Item name
gameItems[199].type = "SKEAN"; // Item type
gameItems[199].icon = skeanImage
gameItems[199].info = "Creates thrower's illusion\nUse with \223Throw\224 command"
gameItems[199].price = 400
}
//==========================================================
// RELIC
//==========================================================
{
  gameItems[200] = new relicItemObject("Googles", 500, "Protects against \223Dark\224");
  gameItems[200].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[201] = new relicItemObject("Star Pendant", 500, "Protects against \223Poison\224");
  gameItems[201].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[202] = new relicItemObject("Peace Ring", 3000, "Protects against \223Berserk\224, \223Muddle\224");
  gameItems[202].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[203] = new relicItemObject("Amulet", 5000, "Protects against \223Poison\224, \223Dark\224, \223Zombie\224");
  gameItems[203].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[204] = new relicItemObject("White Cape", 5000, "Protects against \223Imp\224, \223Mute\224", 0, 0, 0, 0, 0, 0, 0, 0, 10);
  gameItems[204].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[205] = new relicItemObject("Jewel Ring", 1000, "Protects against \223Dark\224, \223Petrify\224");
  gameItems[205].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[206] = new relicItemObject("Fairy Ring", 1500, "Protects against \223Poison\224, \223Dark\224");
  gameItems[206].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[207] = new relicItemObject("Barrier Ring", 500, "Casts \223Shell\224 when HP is low", 0, 0, 0, 2);
  gameItems[207].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[208] = new relicItemObject("MithrilGlove", 700, "Casts \223Safe\224", 0, 0, 0, 0, 0, 6);
  gameItems[208].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[209] = new relicItemObject("Guard Ring", 5000, "Casts \223Safe\224");
  gameItems[209].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[210] = new relicItemObject("RunningShoes", 7000, "Casts \223Haste\224");
  gameItems[210].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[211] = new relicItemObject("Wall Ring", 6000, "Casts \223Reflect\224");
  gameItems[211].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[212] = new relicItemObject("Cherub Down", 6300, "Casts \223Float\224");
  gameItems[212].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[213] = new relicItemObject("Cure Ring", 8000, "Casts \223Regen\224");
  gameItems[213].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[214] = new relicItemObject("True Knight", 1000, "Protects party members who\nare low in HP");
  gameItems[214].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[215] = new relicItemObject("DragoonBoots", 9000, "Changes \223Fight\224 into \223Jump\224");
  gameItems[215].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4];
  
  gameItems[216] = new relicItemObject("Zephr Cape", 7000, "Dodges attacks more easily", 0, 0, 0, 0, 0, 0, 0, 0, 10);
  gameItems[216].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[217] = new relicItemObject("Czarina Ring", 3000, "Casts \223Safe\224, \223Shell\224 when HP is low");
  gameItems[217].equip = [0, 9, 4];
  
  gameItems[218] = new relicItemObject("Cursed Ring", 2, "Is cursed");
  gameItems[218].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[219] = new relicItemObject("Earrings", 5000, "Raises magic damage\nMore powerful id paired");
  gameItems[219].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[220] = new relicItemObject("Atlas Armlet", 5000, "Raises fight damage");
  gameItems[220].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[221] = new relicItemObject("Blizzard Orb", 2, "Equip on sasquatch, and...", 0, 0, 0, 5);
  gameItems[221].equip = [12];
  
  gameItems[222] = new relicItemObject("Rage Ring", 2, "Equip on sasquatch, and...", 5);
  gameItems[222].equip = [12];
  
  gameItems[223] = new relicItemObject("Sneak Ring", 3000, "Raises success rate of Steal", 0, 5);
  gameItems[223].equip = [1, 13];
  
  gameItems[224] = new relicItemObject("Pod Bracelet", 2, "Casts \223Safe\224, \223Shell\224");
  gameItems[224].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[225] = new relicItemObject("Hero Ring", 2, "Raises fight and magic damage");
  gameItems[225].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[226] = new relicItemObject("Ribbon", 2, "Protects from all status ailments");
  gameItems[226].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[227] = new relicItemObject("Muscle Belt", 2, "Raises HP by 1/2");
  gameItems[227].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[228] = new relicItemObject("Crystal Orb", 2, "Raises MP by 1/2");
  gameItems[228].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[229] = new relicItemObject("Gold Hairpin", 2, "Halves MP consumed");
  gameItems[229].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[230] = new relicItemObject("Economizer", 2, "Cuts MP consumed to 1");
  gameItems[230].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4];
  
  gameItems[231] = new relicItemObject("Theif Glove", 2, "Changes \223Steal\224 into \223Capture\224");
  gameItems[231].equip = [1, 13];
  
  gameItems[232] = new relicItemObject("Gaunlet", 2, "One weapon can be held with 2 hands to increase damage", 0, 0, 0, 0, 0, 5);
  gameItems[232].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[233] = new relicItemObject("Genji Glove", 2, "Possible to equip each hand with a weapon", 0, 0, 0, 0, 0, 5);
  gameItems[233].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4];
  
  gameItems[234] = new relicItemObject("Hyper Wrist", 8000, "Raises vigor");
  gameItems[234].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[235] = new relicItemObject("Offering", 2, "Changes \223Fight\224 into \223X-Fight\224");
  gameItems[235].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[236] = new relicItemObject("Beads", 4000, "Randomly evades enemies' attack", 0, 0, 0, 0, 0, 0, 20);
  gameItems[236].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[237] = new relicItemObject("Black Belt", 5000, "Randomly counterattacks when attacked");
  gameItems[237].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[238] = new relicItemObject("Coin Toss", 2, "Changes \223Slot\224 into \223GP Rain\224");
  gameItems[238].equip = [13, 7];
  
  gameItems[239] = new relicItemObject("FakeMustache", 2, "Changes \223Sketch\224 into \223Control\224");
  gameItems[239].equip = [9, 13];
  
  gameItems[240] = new relicItemObject("Gem Box", 2, "Changes \223Magic\224 into \223X-Magic\224");
  gameItems[240].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4];
  
  gameItems[241] = new relicItemObject("Dragon Horn", 2, "Makes \223Jump\224 continous");
  gameItems[241].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4];
  
  gameItems[242] = new relicItemObject("Merit Award", 2, "Allows heavy armor. ect. to be equipped");
  gameItems[242].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[243] = new relicItemObject("Memento Ring", 2, "Departed mom's love protects against fatal magic attacks");
  gameItems[243].equip = [10, 9];
  
  gameItems[244] = new relicItemObject("Safety Bit", 2, "Protects from mortal magic attacks");
  gameItems[244].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[245] = new relicItemObject("Relic Ring", 2, "Makes body cold");
  gameItems[245].equip = [12];
  
  gameItems[246] = new relicItemObject("Moogle Charm", 2, "No random encounters");
  gameItems[246].equip = [11];
  
  gameItems[247] = new relicItemObject("Charm Bangle", 2, "Encounters fewer random enemies");
  gameItems[247].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[248] = new relicItemObject("Marvel Shoes", 2, "Creates various effects");
  gameItems[248].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[249] = new relicItemObject("Back Guard", 7000, "Evades \223Back attack\224 and \223Pincer attack\224");
  gameItems[249].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[250] = new relicItemObject("Gale Hairpin", 8000, "Raises \223Premptive attack\224 rate");
  gameItems[250].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[251] = new relicItemObject("Sniper Sight", 3000, "Ensures 100% \223Fight\224 hit rate");
  gameItems[251].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[252] = new relicItemObject("Exp. Egg", 2, "Doubles obtained Exp.");
  gameItems[252].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[253] = new relicItemObject("Tintinbar", 2, "Recovers HP with each step");
  gameItems[253].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
  
  gameItems[254] = new relicItemObject("Sprint Shoes", 1500, "Allows person to sprint");
  gameItems[254].equip = [0, 1, 2, 3, 10, 11, 9, 8, 13, 5, 6, 7, 4, 12];
}

var rareItems = [];

{
  item = new Object
  item.name = "Cider"
  item.info = "Cider, taken from a merchant."
  rareItems[rareItems.length] = item
  
  item = new Object
  item.name = "Old Clock-Key"
  item.info = "An old clock-key, found on a\nsoldier."
  rareItems[rareItems.length] = item
  
  item = new Object
  item.name = "Fish"
  item.info = "A yummy fish"
  rareItems[rareItems.length] = item
  
  item = new Object
  item.name = "Fish"
  item.info = "Just a fish"
  rareItems[rareItems.length] = item
  
  item = new Object
  item.name = "Fish"
  item.info = "A rotten fish"
  rareItems[rareItems.length] = item
  
  item = new Object
  item.name = "Fish"
  item.info = "Fish"
  rareItems[rareItems.length] = item
 
  item = new Object
  item.name = "Lump Of Metal"
  item.info = "A heavy weight. Put it into a\nchest, and..."
  rareItems[rareItems.length] = item
  
  item = new Object
  item.name = "Lola's Letter"
  item.info = "Thanks for all those flowers!\nI'm worried about you..."
  rareItems[rareItems.length] = item
  
  item = new Object
  item.name = "Coral"
  item.info = "Piece of coral, found in the cave\nnear Ebot's Rock."
  rareItems[rareItems.length] = item
  
  item = new Object
  item.name = "Books"
  item.info = "Simple book on machinery...\nAnd \223Book of Secrets\224..."
  rareItems[rareItems.length] = item
  
  item = new Object
  item.name = "Royal Letter"
  item.info = "At a star-shaped mountain\nrange..."
  rareItems[rareItems.length] = item
  
  item = new Object
  item.name = "Rust-Rid"
  item.info = "Rust solvent"
  rareItems[rareItems.length] = item
  
  item = new Object
  item.name = "Autograph"
  item.info = "An opera singer's autograph"
  rareItems[rareItems.length] = item
  
  item = new Object
  item.name = "Manicure"
  item.info = "Pretty, red manicure"
  rareItems[rareItems.length] = item
  
  item = new Object
  item.name = "Opera Record"
  item.info = "Has a small scratch"
  rareItems[rareItems.length] = item
  
  item = new Object
  item.name = "Magn.Glass"
  item.info = "A convex lens"
  rareItems[rareItems.length] = item
  
  item = new Object
  item.name = "Eerie Stone"
  item.info = "A stone never seen"
  rareItems[rareItems.length] = item
  
  item = new Object
  item.name = "Odd Picture"
  item.info = "A very curious picture"
  rareItems[rareItems.length] = item
  
  item = new Object
  item.name = "Dull Picture"
  item.info = "Quite a common picture"
  rareItems[rareItems.length] = item
  
  item = new Object
  item.name = "Pendant"
  item.info = "A pendant worn by the girl who\npilots the Magitek Armor."
  rareItems[rareItems.length] = item
}

partyRareItems = [];
for (var i = 0; i < rareItems.length; i++)
{
  partyRareItems[i] = rareItems[i];
}

partyRareItems[4] = undefined;

function addItem(item)
{
  log.write("Trying to add " + item.name + " back to inventory");
  for (var i = 0; i < partyItems.length; i++)
  {
    if (item == partyItems[i])
    {
      if (partyItems[i].quantity < 99)
      {
        log.write("Quantity is " + partyItems[i].quantity + ". So add item back to inventory");
        return partyItems[i].quantity++;
      }
      else
      {
        log.write("Quantity is " + partyItems[i].quantity + ". So cannot add back to inventory");
        return;
      }
    }
  }
}

function removeItem(item)
{
  log.write("Removing " + item.name + " from inventory");
  for (var i = 0; i < partyItems.length; i++)
  {
    if (partyItems[i] == item)
    {
      partyItems[i].quantity--;
      if (partyItems[i].quantity <= 0)
      {
        partyItems[i] = undefined;
        return log.write("Last of that item, so item comletely removed");
      }
      return log.write("One of that item removed");
    }
  }
}